/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.neapolitan.common.entity.goals;

import com.minecraftabnormals.neapolitan.core.other.NeapolitanTags;
import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class AvoidBlockGoal<T extends LivingEntity>
extends Goal {
    protected final CreatureEntity entity;
    private final double farSpeed;
    private final double nearSpeed;
    protected BlockPos avoidTarget;
    protected final int avoidDistance;
    protected Path path;
    protected final PathNavigator navigation;
    protected final Predicate<LivingEntity> avoidTargetSelector;
    protected final Predicate<LivingEntity> field_203784_k;

    public AvoidBlockGoal(CreatureEntity entityIn, int avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this(entityIn, p_200828_0_ -> true, avoidDistanceIn, farSpeedIn, nearSpeedIn, EntityPredicates.field_188444_d::test);
    }

    public AvoidBlockGoal(CreatureEntity entityIn, Predicate<LivingEntity> targetPredicate, int distance, double nearSpeedIn, double farSpeedIn, Predicate<LivingEntity> p_i48859_9_) {
        this.entity = entityIn;
        this.avoidTargetSelector = targetPredicate;
        this.avoidDistance = distance;
        this.farSpeed = nearSpeedIn;
        this.nearSpeed = farSpeedIn;
        this.field_203784_k = p_i48859_9_;
        this.navigation = entityIn.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (NeapolitanTags.Blocks.CREEPER_REPELLENTS.func_230236_b_().isEmpty()) {
            return false;
        }
        Optional<BlockPos> optional = this.findNearestRepellent(this.entity.func_130014_f_(), this.entity);
        if (!optional.isPresent()) {
            return false;
        }
        this.avoidTarget = optional.get();
        Vector3d vec3d = RandomPositionGenerator.func_75461_b((CreatureEntity)this.entity, (int)this.avoidDistance, (int)7, (Vector3d)new Vector3d((double)this.avoidTarget.func_177958_n(), (double)this.avoidTarget.func_177956_o(), (double)this.avoidTarget.func_177952_p()));
        if (vec3d == null) {
            return false;
        }
        if (this.avoidTarget.func_218140_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, false) < this.avoidTarget.func_218140_a(this.entity.func_226277_ct_(), this.entity.func_226278_cu_(), this.entity.func_226281_cx_(), false)) {
            return false;
        }
        this.path = this.navigation.func_225466_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 0);
        return this.path != null;
    }

    private Optional<BlockPos> findNearestRepellent(World world, CreatureEntity entity) {
        return BlockPos.func_239584_a_((BlockPos)entity.func_233580_cy_(), (int)this.avoidDistance, (int)4, pos -> world.func_180495_p(pos).func_235714_a_(NeapolitanTags.Blocks.CREEPER_REPELLENTS));
    }

    public boolean func_75253_b() {
        return !this.navigation.func_75500_f();
    }

    public void func_75249_e() {
        this.navigation.func_75484_a(this.path, this.farSpeed);
    }

    public void func_75251_c() {
        this.avoidTarget = null;
    }

    public void func_75246_d() {
        if (this.entity.func_70092_e((double)this.avoidTarget.func_177958_n(), (double)this.avoidTarget.func_177956_o(), (double)this.avoidTarget.func_177952_p()) < 49.0) {
            this.entity.func_70661_as().func_75489_a(this.nearSpeed);
        } else {
            this.entity.func_70661_as().func_75489_a(this.farSpeed);
        }
    }
}

